package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Participant;

public class OEFOIFRealDocumentRuleEvaluator extends AbstractDocumentRuleEvaluator {

    /**
     * Is a specific document required for a location?
     * 
     */
    @Override
    public boolean isRequired(final Request req, final DataSource ds, final DocumentTemplate temp, final Location site,
            final boolean isIndependentOnly) {

        if (isDartRequest(req) == false) {
            return false;
        }

        DartRequest dartRequest = (DartRequest) req;

        // IRB Approval of Waiver of HIPAA is required of all sites if the HIPAA waiver is true
        if (temp.getName().startsWith("IRB Approval of Waiver of HIPAA") && dartRequest.isHipaaWaiver() == true) {
            return true;
        }

        // Research and Development (RD) Committee Approval is required of all sites
        if (temp.getName().startsWith("Research and Development (RD) Committee Approval")) {
            return true;
        }

        // Research Study Institutional Review Board (IRB) Approval is required of all sites
        if (temp.getName().startsWith("Research Study Institutional Review Board (IRB) Approval")) {
            return true;
        }

        Location primarySite = req.getPrimaryLocation();
        if (primarySite != null) {

            // Research Request Memo is required for the primary site
            if (temp.getName().startsWith("Research Request Memo") && site.getId() == primarySite.getId()) {
                return true;
            }

            // Sample Informed Consent is required for the primary site if the HIPAA patient consent is true
            if (temp.getName().startsWith("Sample Informed Consent") && site.getId() == primarySite.getId()
                    && dartRequest.isHipaaConsent() == true) {
                return true;
            }

            // Data Use Agreement is required for the primary site
            if (temp.getName().startsWith("OEF-OIF Data Use Agreement") && site.getId() == primarySite.getId()) {
                return true;
            }

            // Research Protocol is required for the primary site
            if (temp.getName().startsWith("Research Protocol") && site.getId() == primarySite.getId()) {
                return true;
            }

            // As of 8/13/2014 (Real SSN BRD item 1.2):
            // Real SSN Access Request is required for the primary site, if realSSN is selected
            if (temp.getName().startsWith("Real SSN Access Request") && site.getId() == primarySite.getId()
                    && dartRequest.isRealSSN() == true) {

                // As of 2/25/2015: Real SSN Access Request no longer required for any Independent Approver Workflow
                // if( dartRequest.getWorkflowTypeId() == WorkflowResolver.WF_NDS ) {
                if (isIndependentOnly == false) {
                    return true;
                }
                // }
            }
        }

        return false;
    }

    @Override
    public boolean isRequired(Request req, DataSource ds, DocumentTemplate temp, Group admin, Location site,
            final boolean isIndependentOnly) {

        Location primarySite = req.getPrimaryLocation();
        if (primarySite != null) {

            if (temp.getName().startsWith(NDS_DATA_USE_AGREEMENT) && primarySite.getId() == site.getId()
                    && admin.getName().equals(DART_NDS_ADMINISTRATORS)) {
                return true;
            }

            if (temp.getName().startsWith(RESEARCH_PRIVACY_REVIEW_CHECKLIST) && primarySite.getId() == site.getId()
                    && admin.getName().equals(DART_PRIVACY_ADMINISTRATORS)) {
                return true;
            }

            // Note: currently unused
            if (temp.getName().startsWith("VSSC OEF/OIF Roster File DUA") && primarySite.getId() == site.getId()
                    && admin.getName().equals("DART VSSC Administrators")) {
                return true;
            }

            //
            // 5/21/2014: upload the OEF-OIF Data Use Agreement in the Admin Documents tab
            // Data Use Agreement is required for the primary site
            if (temp.getName().startsWith("OEF-OIF Data Use Agreement") && primarySite.getId() == site.getId()
                    && admin.getName().equals("OEF-OIF Administrators")) {
                return true;
            }

        }// end if

        return false;
    }

    @Override
    public boolean isRequired(Request req, DataSource ds, DocumentTemplate temp, Group admin, Participant participant,
            final boolean isIndependentOnly) {
        if (temp.getName().startsWith(ORD_9957) && participant.getDataAccess() == true
                && admin.getName().equals(DART_ORD_ADMINISTRATORS)) {
            return true;
        }

        return false;
    }
}
